<?php
// === AJOUT DES HEADERS CORS POUR AUTORISER ACCÈS EXTERNE ===
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

// === REPONSE OPTIONS POUR LES PRÉREQUÊTES CORS ===
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

header('Content-Type: application/json');


$filename = "ab_status.json";
if (!file_exists($filename)) {
    file_put_contents($filename, "{}");
}

$abData = json_decode(file_get_contents($filename), true);

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    echo json_encode($abData);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents("php://input"), true);
    $tournee = $input["tournee"] ?? null;
    $ab = $input["ab"] ?? false;

    if ($tournee !== null) {
        $abData[$tournee] = $ab;
        file_put_contents($filename, json_encode($abData, JSON_PRETTY_PRINT));
    }

    echo json_encode(["success" => true]);
    exit;
}
?>
